<#ibiztemplate>
TARGET=PSAPPUTIL
</#ibiztemplate>
import UtilService from '../util-service';
<#if item.getStoagePSAppDataEntity()??>
<#assign stoageDataEntity = item.getStoagePSAppDataEntity() />
import ${srfclassname('${stoageDataEntity.getCodeName()}')}Service from '@/service/${srffilepath2(stoageDataEntity.getCodeName())}/${srffilepath2(stoageDataEntity.getCodeName())}-service';
</#if>

/**
 * ${item.getName()}功能服务对象基类
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}UtilServiceBase
 */
export default class ${srfclassname('${item.getCodeName()}')}UtilServiceBase extends UtilService {
<#if item.getStoagePSAppDataEntity()??>
<#assign stoageDataEntity = item.getStoagePSAppDataEntity() />

    /**
     * 存储数据服务
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */ 
    public stoageDataService: ${srfclassname('${stoageDataEntity.getCodeName()}')}Service = new ${srfclassname('${stoageDataEntity.getCodeName()}')}Service();
</#if>

    /**
     * 获取数据行为
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */ 
    public loadAction: string = "${item.getGetPSAppDEAction().getCodeName()}";

    /**
     * 建立数据行为
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */ 
    public createAction: string = "${item.getCreatePSAppDEAction().getCodeName()}";

    /**
     * 更新数据行为
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */ 
    public updateAction: string = "${item.getUpdatePSAppDEAction().getCodeName()}";

    /**
     * 删除数据行为
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */ 
    public removeAction: string = "${item.getRemovePSAppDEAction().getCodeName()}";

    /**
     * Creates an instance of  ${srfclassname('${item.getCodeName()}')}UtilServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
    * 初始化基础参数
    *
    * @memberof ${srfclassname('${item.getCodeName()}')}UtilServiceBase
    */
   public initBasicParam(){
        <#if item.getModelIdPSAppDEField()??>this.modelIdField = "${item.getModelIdPSAppDEField().getCodeName()?lower_case}";</#if>
        <#if item.getModelPSAppDEField()??>this.modelField = "${item.getModelPSAppDEField().getCodeName()?lower_case}";</#if>
        <#if item.getAppIdPSAppDEField()??>this.appIdField = "${item.getAppIdPSAppDEField().getCodeName()?lower_case}";</#if>
        <#if item.getUserIdPSAppDEField()??>this.userIdField = "${item.getUserIdPSAppDEField().getCodeName()?lower_case}";</#if>
<#if item.getStoagePSAppDataEntity()??>
<#assign stoageDataEntity = item.getStoagePSAppDataEntity() />
        this.stoageEntityName ="${stoageDataEntity.getCodeName()?lower_case}";
        this.stoageEntityKey ="${stoageDataEntity.getKeyPSAppDEField().getCodeName()?lower_case}";
</#if>
   }

    /**
     * 获取模型数据
     * 
     * @param context 应用上下文 
     * @param data 传入模型数据
     * @param isloading 是否加载
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */ 
    public loadModelData(context: any = {},data: any = {}, isloading?: boolean): Promise<any>{
        return new Promise((resolve: any, reject: any) => {
            //从接口加载
            if(data && data.utilServiceName){
                const requestParam:any ={configType:data.utilServiceName,targetType:data.modelid};
                this.stoageDataService.getDynaModel(context,requestParam).then((res:any) =>{
                    if(res && res.status === 200){
                        const data: any = res.data;
                        resolve({status:200,data:(data && data.model)?data.model:[]});
                    }
                }).catch((error:any) =>{
                    reject(error);
                })
            }else{
                let dataStr = window.localStorage.getItem(data.modelid);
                if(dataStr) {
                    const data: any = JSON.parse(dataStr);
                    resolve({status:200,data:data.model});
                } else {
                    resolve({status:200,data:[]});
                }
            }
        });
    }

    /**
     * 保存模型数据
     * 
     * @param context 应用上下文 
     * @param action 操作行为 Update|Create
     * @param data 传入模型数据
     * @param isloading 是否加载
     * @memberof  ${srfclassname('${item.getCodeName()}')}UtilServiceBase
     */ 
    public saveModelData(context: any = {},action:string,data: any = {}, isloading?: boolean):Promise<any>{
        return new Promise((resolve: any, reject: any) => {
            // 存储到数据库
            if(data && data.utilServiceName){
                const requestParam:any ={configType:data.utilServiceName,targetType:data.modelid,model:data.model};
                this.stoageDataService.setDynaModel(context,requestParam).then((res:any) =>{
                    if(res && res.status === 200){
                        resolve({status:200,data:data.model});
                    }
                }).catch((error:any) =>{
                    reject(error);
                })
            }else{
                window.localStorage.setItem(data.modelid, JSON.stringify(data));
                resolve({status:200,data:data.model});
            }
        });   
    }


}